/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.IVWComponentConfiguration;
import filenet.vw.server.VWCapsule;
import filenet.vw.toolkit.admin.property.integrator.IVWAdaptorInfoListener;
import filenet.vw.toolkit.admin.property.integrator.IVWPanelInterface;
import filenet.vw.toolkit.admin.property.integrator.VWAdaptorInfo;
import filenet.vw.toolkit.admin.property.integrator.VWConfigurationModuleRegistrationPanel;
import filenet.vw.toolkit.admin.property.integrator.VWLibraryRegistrationPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.w3c.dom.Node;

public class VWConfigurationPanel
extends JPanel
implements IVWPanelInterface,
ActionListener,
IVWAdaptorInfoListener {
    private static final String PASSWORD_MASK = "*******";
    private Container m_parent = null;
    private VWAdaptorInfo m_adaptorInfo = null;
    private VWSessionInfo m_sessionInfo = null;
    private Hashtable m_classHashtable = null;
    private ClassLoader m_customClassLoader = null;
    private boolean m_bIsModified = false;
    private JComboBox m_typeComboBox = null;
    private JComponent m_initialFocusComponent = null;
    private JButton m_configureButton = null;
    private JTextField m_concurrentThreadsTextField = null;
    private JTextField m_traceLevelTextField = null;
    private JTextField m_pollingRateTextField = null;
    private JComboBox m_startupModeComboBox = null;
    private JTextField m_userNameTextField = null;
    private JPasswordField m_passwordField = null;
    private JTextField m_configContextTextField = null;
    private JTextField m_submapTextField = null;

    public VWConfigurationPanel(Frame parent, VWAdaptorInfo vwAdaptorInfo, VWSessionInfo vwSessionInfo, VWSystemConfiguration vwSystemConfiguration) {
        this.m_parent = parent;
        this.m_adaptorInfo = vwAdaptorInfo;
        this.m_sessionInfo = vwSessionInfo;
        this.initialize(vwSystemConfiguration);
        IVWComponentConfiguration compConfigClass = vwAdaptorInfo.getComponentConfigurationClass();
        if (compConfigClass == null && this.m_typeComboBox.getModel().getSize() > 0) {
            if (this.m_typeComboBox.getSelectedIndex() == -1) {
                this.m_typeComboBox.setSelectedIndex(0);
            }
            if (this.m_classHashtable != null && this.m_adaptorInfo != null && (compConfigClass = (IVWComponentConfiguration)this.m_classHashtable.get((String)this.m_typeComboBox.getSelectedItem())) != null) {
                this.m_adaptorInfo.setComponentConfigurationClass(compConfigClass);
            }
        }
        this.m_adaptorInfo.addPropertyChangeListener(this);
    }

    public VWConfigurationPanel(JDialog parent, VWAdaptorInfo vwAdaptorInfo, VWSessionInfo vwSessionInfo, VWSystemConfiguration vwSystemConfiguration) {
        this.m_parent = parent;
        this.m_adaptorInfo = vwAdaptorInfo;
        this.m_sessionInfo = vwSessionInfo;
        this.initialize(vwSystemConfiguration);
        IVWComponentConfiguration compConfigClass = vwAdaptorInfo.getComponentConfigurationClass();
        if (compConfigClass == null && this.m_typeComboBox.getModel().getSize() > 0) {
            if (this.m_typeComboBox.getSelectedIndex() == -1) {
                this.m_typeComboBox.setSelectedIndex(0);
            }
            if (this.m_classHashtable != null && this.m_adaptorInfo != null && (compConfigClass = (IVWComponentConfiguration)this.m_classHashtable.get((String)this.m_typeComboBox.getSelectedItem())) != null) {
                this.m_adaptorInfo.setComponentConfigurationClass(compConfigClass);
            }
        }
        this.m_adaptorInfo.addPropertyChangeListener(this);
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void releaseResources() {
        this.m_parent = null;
        this.m_sessionInfo = null;
        if (this.m_adaptorInfo != null) {
            this.m_adaptorInfo.releaseResources();
            this.m_adaptorInfo = null;
        }
        if (this.m_classHashtable != null) {
            this.m_classHashtable.clear();
            this.m_classHashtable = null;
        }
        this.m_customClassLoader = null;
        if (this.m_typeComboBox != null) {
            this.m_typeComboBox.removeActionListener(this);
            this.m_typeComboBox.removeAll();
            this.m_typeComboBox = null;
        }
        this.m_initialFocusComponent = null;
        if (this.m_configureButton != null) {
            this.m_configureButton.removeActionListener(this);
            this.m_configureButton.removeAll();
            this.m_configureButton = null;
        }
        if (this.m_startupModeComboBox != null) {
            this.m_startupModeComboBox.removeActionListener(this);
            this.m_startupModeComboBox.removeAll();
            this.m_startupModeComboBox = null;
        }
        if (this.m_concurrentThreadsTextField != null) {
            this.m_concurrentThreadsTextField.removeAll();
            this.m_concurrentThreadsTextField = null;
        }
        if (this.m_traceLevelTextField != null) {
            this.m_traceLevelTextField.removeAll();
            this.m_traceLevelTextField = null;
        }
        if (this.m_pollingRateTextField != null) {
            this.m_pollingRateTextField.removeAll();
            this.m_pollingRateTextField = null;
        }
        if (this.m_userNameTextField != null) {
            this.m_userNameTextField.removeAll();
            this.m_userNameTextField = null;
        }
        if (this.m_passwordField != null) {
            this.m_passwordField.removeAll();
            this.m_passwordField = null;
        }
        if (this.m_configContextTextField != null) {
            this.m_configContextTextField.removeAll();
            this.m_configContextTextField = null;
        }
        if (this.m_submapTextField != null) {
            this.m_submapTextField.removeAll();
            this.m_submapTextField = null;
        }
        this.removeAll();
    }

    public void checkForErrors() throws Exception {
        VWXMLWrapper componentDescriptorWrapper = this.m_adaptorInfo.getComponentDescriptor();
        if (componentDescriptorWrapper == null) {
            throw new VWException("vw.toolkit.admin.property.integrator.VWConfigurationPanel.missingComponentDescriptor", "You must configure the adaptor.");
        }
        Node rootNode = componentDescriptorWrapper.getRootNode();
        this.validateIntegerEntry(this.m_concurrentThreadsTextField, VWResource.ConcurrentThreads, 1);
        this.updateWrapperValue(componentDescriptorWrapper, rootNode, this.m_concurrentThreadsTextField, "concurrent_threads", VWResource.ConcurrentThreads);
        this.validateIntegerEntry(this.m_pollingRateTextField, VWResource.PollingRate, 0);
        this.updateWrapperValue(componentDescriptorWrapper, rootNode, this.m_pollingRateTextField, "polling_rate", VWResource.PollingRate);
        this.updateWrapperValue(componentDescriptorWrapper, rootNode, this.m_startupModeComboBox, "startup_mode", VWResource.StartupMode);
        this.updateWrapperValue(componentDescriptorWrapper, rootNode, this.m_submapTextField, "exception_submap", VWResource.ExceptionSubmap);
        this.updateWrapperValue(componentDescriptorWrapper, rootNode, this.m_userNameTextField, "jaas_username", VWResource.UserName);
        this.updateWrapperValue(componentDescriptorWrapper, rootNode, this.m_passwordField, "jaas_password", null);
        this.updateWrapperValue(componentDescriptorWrapper, rootNode, this.m_configContextTextField, "jaas_configcontext", VWResource.ConfigurationContext);
    }

    public String getInstructions() {
        return VWResource.ConfigureAComponentAdaptor;
    }

    public JComponent getInitialFocusComponent() {
        return this.m_initialFocusComponent;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_typeComboBox)) {
            IVWComponentConfiguration compConfig = (IVWComponentConfiguration)this.m_classHashtable.get((String)this.m_typeComboBox.getSelectedItem());
            if (compConfig != null && compConfig != this.m_adaptorInfo.getComponentConfigurationClass()) {
                this.m_adaptorInfo.setComponentConfigurationClass(compConfig);
            }
        } else if (object.equals(this.m_configureButton)) {
            this.doGetComponentDescriptor();
            this.m_configureButton.requestFocus();
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof JDialog)) continue;
                parent.requestFocus();
                break;
            }
            this.m_configureButton.requestFocus();
        }
    }

    public void adaptorInfoChanged() {
        try {
            if (this.m_adaptorInfo == null) {
                return;
            }
            VWXMLWrapper componentDescriptorWrapper = this.m_adaptorInfo.getComponentDescriptor();
            if (componentDescriptorWrapper != null) {
                Node rootNode = componentDescriptorWrapper.getRootNode();
                this.updateControlValue(componentDescriptorWrapper, rootNode, this.m_concurrentThreadsTextField, "concurrent_threads");
                this.updateControlValue(componentDescriptorWrapper, rootNode, this.m_pollingRateTextField, "polling_rate");
                this.updateControlValue(componentDescriptorWrapper, rootNode, this.m_startupModeComboBox, "startup_mode");
                this.updateControlValue(componentDescriptorWrapper, rootNode, this.m_submapTextField, "exception_submap");
                this.updateControlValue(componentDescriptorWrapper, rootNode, this.m_userNameTextField, "jaas_username");
                this.updateControlValue(componentDescriptorWrapper, rootNode, this.m_passwordField, "jaas_password");
                this.updateControlValue(componentDescriptorWrapper, rootNode, this.m_configContextTextField, "jaas_configcontext");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(VWSystemConfiguration vwSystemConfiguration) {
        try {
            try {
                Vector adaptorNames = this.findComponentConfigurationClasses(vwSystemConfiguration);
                this.createControls(adaptorNames);
                VWXMLWrapper componentAdaptorWrapper = this.m_adaptorInfo.getComponentDescriptor();
                if (componentAdaptorWrapper != null && this.m_classHashtable != null) {
                    Node rootNode;
                    String adaptorClass;
                    if (this.m_typeComboBox != null) {
                        this.m_typeComboBox.removeActionListener(this);
                    }
                    if ((adaptorClass = VWXMLWrapper.getNodeValue(rootNode = componentAdaptorWrapper.getRootNode(), "adaptor_class")) != null && adaptorClass.length() > 0) {
                        boolean bFound = false;
                        Enumeration keys = this.m_classHashtable.keys();
                        if (keys != null) {
                            while (keys.hasMoreElements()) {
                                IVWComponentConfiguration compConfig = (IVWComponentConfiguration)this.m_classHashtable.get((String)keys.nextElement());
                                if (compConfig == null || VWStringUtils.compare(compConfig.getAdaptorClass(), adaptorClass) != 0) continue;
                                this.m_adaptorInfo.setComponentConfigurationClass(compConfig);
                                this.m_typeComboBox.setSelectedItem(compConfig.getName());
                                bFound = true;
                            }
                        }
                        if (!bFound) {
                            String adaptorName = VWXMLWrapper.getNodeValue(rootNode, "adaptor_name");
                            this.m_typeComboBox.addItem(adaptorName);
                            this.m_typeComboBox.setSelectedItem(adaptorName);
                        }
                    }
                }
                this.adaptorInfoChanged();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var10_11 = null;
                if (this.m_typeComboBox != null) {
                    this.m_typeComboBox.addActionListener(this);
                }
            }
            Object var10_10 = null;
            if (this.m_typeComboBox != null) {
                this.m_typeComboBox.addActionListener(this);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (this.m_typeComboBox != null) {
                this.m_typeComboBox.addActionListener(this);
            }
            throw throwable;
        }
    }

    private Vector findComponentConfigurationClasses(VWSystemConfiguration vwSystemConfiguration) {
        try {
            this.m_classHashtable = new Hashtable();
            VWLibraryRegistrationPanel libPanel = null;
            if (this.m_parent instanceof Frame) {
                libPanel = new VWLibraryRegistrationPanel((Frame)this.m_parent, vwSystemConfiguration);
            } else if (this.m_parent instanceof JDialog) {
                libPanel = new VWLibraryRegistrationPanel((JDialog)this.m_parent, vwSystemConfiguration);
            }
            VWConfigurationModuleRegistrationPanel regPanel = new VWConfigurationModuleRegistrationPanel(this.m_parent, vwSystemConfiguration, libPanel);
            this.m_customClassLoader = regPanel.getCustomClassLoader();
            this.addComponentConfigurationToHashtable("filenet.vw.integrator.adaptors.java.VWJavaConfigurationModule", this.m_customClassLoader);
            if (this.m_sessionInfo.isWorkPlaceWebApp()) {
                this.addComponentConfigurationToHashtable("filenet.vw.integrator.adaptors.jms.VWJMSConfigurationModule", this.m_customClassLoader);
            }
            Vector configurationModuleClasses = regPanel.getConfigurationModuleClasses();
            for (int i = 0; i < configurationModuleClasses.size(); ++i) {
                this.addComponentConfigurationToHashtable((String)configurationModuleClasses.elementAt(i), this.m_customClassLoader);
            }
            Enumeration keys = this.m_classHashtable.keys();
            if (keys != null) {
                Vector<String> adaptorNames = new Vector<String>();
                while (keys.hasMoreElements()) {
                    adaptorNames.addElement((String)keys.nextElement());
                }
                return adaptorNames;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void addComponentConfigurationToHashtable(String className, ClassLoader classLoader) {
        try {
            Object configClass;
            if (className != null && className.length() > 0 && classLoader != null && (configClass = classLoader.loadClass(className).newInstance()) != null && configClass instanceof IVWComponentConfiguration) {
                this.m_classHashtable.put(((IVWComponentConfiguration)configClass).getName(), configClass);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(Vector adaptorNames) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.3;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.add((Component)this.getTopPanel(adaptorNames), gbCons);
            ++gbCons.gridy;
            this.add((Component)this.getMiddlePanel(), gbCons);
            ++gbCons.gridy;
            this.add((Component)this.getBottomPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getTopPanel(Vector adaptorNames) {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new VWTitledBorder(VWResource.Adaptor));
            GridBagConstraints gbCons = new GridBagConstraints();
            String title = VWResource.Adaptor + " ";
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            JLabel label = new JLabel(VWResource.Colon.toString(VWResource.Adaptor));
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.Adaptor, title + VWResource.Adaptor);
            panel.add((Component)label, gbCons);
            gbCons.gridwidth = -1;
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_typeComboBox = new JComboBox(adaptorNames);
            this.m_typeComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_initialFocusComponent = this.m_typeComboBox;
            this.m_typeComboBox.addActionListener(this);
            VWAccessibilityHelper.setLabelFor(label, this.m_typeComboBox);
            this.m_typeComboBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_typeComboBox, gbCons);
            gbCons.gridwidth = 0;
            gbCons.anchor = 24;
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_configureButton = new JButton(VWResource.Configure);
            this.m_configureButton.addActionListener(this);
            this.m_configureButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_configureButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_configureButton, this, title + VWResource.Configure, title + VWResource.Configure);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getMiddlePanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new VWTitledBorder(VWResource.AdaptorProperties));
            GridBagConstraints gbCons = new GridBagConstraints();
            String title = VWResource.AdaptorProperties + " ";
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            JLabel label = new JLabel(VWResource.Colon.toString(VWResource.ConcurrentThreads));
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.ConcurrentThreads, title + VWResource.ConcurrentThreads);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_concurrentThreadsTextField = new JTextField("1");
            panel.add((Component)this.m_concurrentThreadsTextField, gbCons);
            VWAccessibilityHelper.setLabelFor(label, this.m_concurrentThreadsTextField);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.Colon.toString(VWResource.PollingRate));
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.PollingRate, title + VWResource.PollingRate);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_pollingRateTextField = new JTextField("1000");
            panel.add((Component)this.m_pollingRateTextField, gbCons);
            VWAccessibilityHelper.setLabelFor(label, this.m_pollingRateTextField);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.Colon.toString(VWResource.ExceptionSubmap));
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.ExceptionSubmap, title + VWResource.ExceptionSubmap);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_submapTextField = new JTextField("Malfunction");
            panel.add((Component)this.m_submapTextField, gbCons);
            VWAccessibilityHelper.setLabelFor(label, this.m_submapTextField);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.Colon.toString(VWResource.StartupMode));
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.StartupMode, title + VWResource.StartupMode);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            String[] options = new String[]{VWResource.Automatic, VWResource.Manual};
            this.m_startupModeComboBox = new JComboBox<String>(options);
            this.m_startupModeComboBox.setRenderer(new VWLabelListCellRenderer());
            panel.add((Component)this.m_startupModeComboBox, gbCons);
            VWAccessibilityHelper.setLabelFor(label, this.m_startupModeComboBox);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getBottomPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new VWTitledBorder(VWResource.JAASCredentials));
            GridBagConstraints gbCons = new GridBagConstraints();
            String title = VWResource.JAASCredentials;
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            JLabel label = new JLabel(VWResource.Colon.toString(VWResource.UserName));
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.UserName, title + VWResource.UserName);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_userNameTextField = new JTextField();
            panel.add((Component)this.m_userNameTextField, gbCons);
            VWAccessibilityHelper.setLabelFor(label, this.m_userNameTextField);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.Password);
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.Password, title + VWResource.Password);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_passwordField = new JPasswordField();
            panel.add((Component)this.m_passwordField, gbCons);
            VWAccessibilityHelper.setLabelFor(label, this.m_passwordField);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.Colon.toString(VWResource.ConfigurationContext));
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, title + VWResource.ConfigurationContext, title + VWResource.ConfigurationContext);
            gbCons.gridwidth = 3;
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_configContextTextField = new JTextField();
            panel.add((Component)this.m_configContextTextField, gbCons);
            VWAccessibilityHelper.setLabelFor(label, this.m_configContextTextField);
            gbCons.gridwidth = 4;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            label = new JLabel(VWResource.NoteSetComponentInfo);
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.NoteSetComponentInfo, VWResource.NoteSetComponentInfo);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateControlValue(VWXMLWrapper componentDescriptorWrapper, Node parentNode, JComponent control, String nodeName) {
        String nodeValue = VWXMLWrapper.getNodeValue(parentNode, nodeName);
        if (nodeValue != null) {
            if (control instanceof JComboBox) {
                if (control.equals(this.m_startupModeComboBox)) {
                    nodeValue = nodeValue.equals("automatic") ? VWResource.Automatic : VWResource.Manual;
                }
                ((JComboBox)control).setSelectedItem(nodeValue);
            } else if (control instanceof JPasswordField) {
                ((JPasswordField)control).setText(PASSWORD_MASK);
            } else if (control instanceof JTextField) {
                ((JTextField)control).setText(nodeValue);
            }
        }
    }

    private void updateWrapperValue(VWXMLWrapper componentDescriptorWrapper, Node parentNode, JComponent control, String nodeName, String label) throws Exception {
        String newValue = null;
        if (control instanceof JComboBox) {
            newValue = (String)((JComboBox)control).getSelectedItem();
            if (control.equals(this.m_startupModeComboBox)) {
                newValue = VWStringUtils.compare(newValue, VWResource.Automatic) == 0 ? "automatic" : "manual";
            }
        } else if (control instanceof JPasswordField) {
            newValue = new String(this.m_passwordField.getPassword());
            if (newValue != null && VWStringUtils.compare(newValue, PASSWORD_MASK) != 0) {
                if ((newValue = newValue.trim()).length() > 0) {
                    VWCapsule vwCapsule = new VWCapsule(newValue);
                    newValue = vwCapsule.getStr();
                }
            } else {
                newValue = null;
            }
        } else if (control instanceof JTextField) {
            newValue = ((JTextField)control).getText();
        }
        if (newValue != null && newValue.length() > 0) {
            String oldValue = VWXMLWrapper.getNodeValue(parentNode, nodeName);
            if (VWStringUtils.compare(oldValue, newValue) != 0) {
                componentDescriptorWrapper.setNodeValue(parentNode, nodeName, newValue);
                this.m_bIsModified = true;
            }
        } else if (label != null) {
            throw new VWException("vw.toolkit.admin.property.integrator.VWConfigurationPanel.invalidConfigurationValue", "You must provide a valid value for the {0} property.", label);
        }
    }

    private void doGetComponentDescriptor() {
        block12: {
            try {
                IVWComponentConfiguration configurationModule = this.m_adaptorInfo.getComponentConfigurationClass();
                if (configurationModule != null) {
                    String newComponentDescriptor = null;
                    if (this.m_parent instanceof Frame) {
                        newComponentDescriptor = configurationModule.getComponentDescriptor((Frame)this.m_parent, this.m_adaptorInfo.getComponentDescriptorString(), this.m_customClassLoader);
                    } else if (this.m_parent instanceof Dialog) {
                        newComponentDescriptor = configurationModule.getComponentDescriptor((Dialog)this.m_parent, this.m_adaptorInfo.getComponentDescriptorString(), this.m_customClassLoader);
                    }
                    if (newComponentDescriptor != null) {
                        String oldComponentDescriptor = this.m_adaptorInfo.getComponentDescriptorString();
                        if (oldComponentDescriptor != null && VWStringUtils.compare(oldComponentDescriptor, newComponentDescriptor) == 0) {
                            return;
                        }
                        this.m_adaptorInfo.setComponentDescriptor(newComponentDescriptor);
                        this.adaptorInfoChanged();
                        this.m_bIsModified = true;
                    }
                } else {
                    if (this.m_parent instanceof Frame) {
                        VWMessageDialog.showOptionDialog((Frame)this.m_parent, VWResource.CannotRetrieveAdaptorConfiguration, VWResource.ErrorMessage, 1);
                    }
                    if (this.m_parent instanceof JDialog) {
                        VWMessageDialog.showOptionDialog((JDialog)this.m_parent, VWResource.CannotRetrieveAdaptorConfiguration, VWResource.ErrorMessage, 1);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_parent instanceof Frame) {
                    VWMessageDialog.showOptionDialog((Frame)this.m_parent, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
                }
                if (!(this.m_parent instanceof JDialog)) break block12;
                VWMessageDialog.showOptionDialog((JDialog)this.m_parent, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
            }
        }
    }

    private void validateIntegerEntry(JTextField textField, String label, int nMinValue) throws Exception {
        int nValue = -1;
        try {
            nValue = Integer.parseInt(textField.getText());
        }
        catch (Exception ex) {
            throw new VWException("vw.toolkit.admin.property.integrator.VWConfigurationPanel.invalidIntegerValue", "You must provide a valid integer value for the {0} property.", label);
        }
        if (nValue < nMinValue) {
            throw new VWException("vw.toolkit.admin.property.integrator.VWConfigurationPanel.integerValueGreaterThanOrEqualTo", "You must provide an integer value greater than or equal to {0} for the {1} property.", Integer.toString(nMinValue), label);
        }
    }
}

